package de.bebagoe.figuren;

public abstract class Figur {
    protected double xpos, ypos;

    public Figur(double x, double y) {
        if (x < 0 || y < 0)
            throw new IllegalArgumentException("Figur partiell außerhalb");
        xpos = x;
        ypos = y;
        super();
    }

    public Figur() {
        xpos = 100.0;
        ypos = 100.0;
        super();
    }

    public double getXpos() { return xpos; }
    public double getYpos() { return ypos; }

    public void wo() {
        IO.println("\nOben links: (" + xpos + ", " + ypos + ")");
    }

    final public void oleck() {
        IO.print("\nOben links: (" + xpos + ", " + ypos + ")");
    }

    public abstract double meldeInhalt();

    abstract public double abstand(double x, double y);
}